package eu.europa.ec.taxud.cesop.domain;

import java.util.List;

import lombok.Getter;
import lombok.Setter;

/**
 * Represents a part of Payment Data Message containing either a list of transactions for a single payee (full or partial) or information about a payee.
 * Such splitting technique is required for streaming processing of large files.
 */
@Getter
@Setter
public class XmlPaymentDataMsgPart {
    private Long partNumber;
    private PaymentDataMsgPartContentType contentType;
    private XmlReportedPayee xmlReportedPayee;
    private List<XmlReportedTransaction> xmlReportedTransactions;
    private boolean isError;
}
